# - Config file for the rocm_smi package
# It defines the following variables
#  ROCM_SMI_INCLUDE_DIRS - include directories for rocm_smi
#  ROCM_SMI_LIBRARIES    - libraries to link against

# Compute paths

####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was rocm_smi-config.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

# Use original install prefix when loaded through a "/usr move"
# cross-prefix symbolic link such as /lib -> /usr/lib.
get_filename_component(_realCurr "${CMAKE_CURRENT_LIST_DIR}" REALPATH)
get_filename_component(_realOrig "/usr/lib64/cmake/rocm_smi" REALPATH)
if(_realCurr STREQUAL _realOrig)
  set(PACKAGE_PREFIX_DIR "/usr")
endif()
unset(_realOrig)
unset(_realCurr)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################
get_filename_component(ROCM_SMI_CMAKE_DIR "${CMAKE_CURRENT_LIST_FILE}" PATH)

set_and_check( rocm_smi_INCLUDE_DIR "${PACKAGE_PREFIX_DIR}/include" )
set_and_check( ROCM_SMI_INCLUDE_DIR "${PACKAGE_PREFIX_DIR}/include" )
set_and_check( ROCM_SMI_INCLUDE_DIRS "${PACKAGE_PREFIX_DIR}/include" )
set_and_check( rocm_smi_LIB_DIR "${PACKAGE_PREFIX_DIR}/lib64" )
set_and_check( ROCM_SMI_LIB_DIR "${PACKAGE_PREFIX_DIR}/lib64" )
set_and_check( ROCM_SMI_LIB_DIRS "${PACKAGE_PREFIX_DIR}/lib64" )

# Our library dependencies (contains definitions for IMPORTED targets)
if(NOT TARGET rocm_smi AND NOT rocm_smi_BINARY_DIR)
    include("${ROCM_SMI_CMAKE_DIR}/rocm_smiTargets.cmake")
endif()

# These are IMPORTED targets created by RocmSmiTargets.cmake
# TODO: Need to check if OAM libraries are needed here!
set(ROCM_SMI_LIBRARIES rocm_smi64)
set(ROCM_SMI_LIBRARY rocm_smi64)

check_required_components(rocm_smi)
